/** import needed to ensure Tally type is properly recognized in lsp */
import _React from 'react';

declare global {
  interface Tally {
    loadEmbeds: () => void,
    closePopup: (formId: string) => void,
    openPopup: (
      formId: string,
      options?: {
        /**
         * This is used as a unique identifier used for the "Show only once" and "Don't show after submit" functionality
         */
        key?: string;
        layout?: 'default' | 'modal';
        width?: number;
        alignLeft?: boolean;
        hideTitle?: boolean;
        overlay?: boolean;
        emoji?: {
          text: string;
          animation: 'none' | 'wave' | 'tada' | 'heart-beat' | 'spin' | 'flash' | 'bounce' | 'rubber-band' | 'head-shake';
        };
        /**
         * in milliseconds
         */
        autoClose?: number;
        showOnce?: boolean;
        doNotShowAfterSubmit?: boolean;
        /**
         * when you want to load the form via it's custom domain URL
         */
        customFormUrl?: string;
        hiddenFields?: {
          [key: string]: unknown,
        };
        onOpen?: () => void;
        onClose?: () => void;
        onPageView?: (page: number) => void;
        onSubmit?: (payload: unknown) => void;
      }
    ) => void
  }

  interface Window {
    Tally: Tally | undefined
  }
}

